/**
 * Lexeme
 *
 *	@author: 	Alan Yates <alany@alanyates.com>
 *	@version	$Id: Lexeme.java,v 1.1.1.1 2002/06/23 06:18:01 alany Exp $
 */
public class Lexeme {
	public static final int ATOM = 0;
	public static final int QATOM = 1;
	public static final int LPARA = 2;
	public static final int RPARA = 3;
	public static final int COMMA = 4;
	public static final int SEMI = 5;
	public static final int COMMENT = 6;

	public static final String[] types = {
		"atom",
		"quoted-atom",
		"left",
		"right",
		"comma",
		"semi-colon",
		"comment"
	};

	public long line;
	public int type;
	public String value;
	
	public Lexeme(long line, int type, String value) {
		this.line = line;
		this.type = type;
		this.value = value;
	}

	public String toString() {
		return "lexeme(" + this.line + ", " + this.types[this.type] + ", \"" + this.value + "\")";
	}
}
